/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Set;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPotions;
import lotr.common.LOTRReflection;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.fac.LOTRFaction;
import lotr.common.world.biome.LOTRBiomeGenOcean;
import net.minecraft.block.BlockSponge;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;

public class LOTRPlayerFallEventHandler3 {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (player.func_70644_a(LOTRPotions.immune)) {
            for (Potion potion : Potion.field_76425_a) {
                if (potion == null || !LOTRReflection.isBadEffect(potion)) continue;
                player.func_82170_o(potion.field_76415_H);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!(event.entity instanceof EntityPlayer) || !(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityLivingBase entity = event.entityLiving;
        if (entity == null) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        DamageSource source = event.source;
        if (source == null || source.func_76346_g() == null) {
            return;
        }
        if (source.func_76346_g() instanceof EntityDragon && LOTRLevelData.getData(entityplayer) != null) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.playerDeathDragon);
        }
        EntityPlayer targetPlayer = (EntityPlayer)event.entity;
        EntityPlayer killerPlayer = (EntityPlayer)event.source.func_76346_g();
        if (targetPlayer == null || killerPlayer == null) {
            return;
        }
        if (!targetPlayer.func_70005_c_().equals("FirstKalik")) {
            return;
        }
        if (LOTRLevelData.getData(killerPlayer) == null) {
            return;
        }
        LOTRLevelData.getData(killerPlayer).addAchievement(LOTRAchievement.killDeveloper);
        ItemStack gunpowderStack = new ItemStack(Items.field_151016_H, 1, 0);
        gunpowderStack.func_151001_c("\u0427\u0451\u0440\u043d\u0430\u044f \u043c\u0435\u0442\u043a\u0430");
        killerPlayer.field_71071_by.func_70441_a(gunpowderStack);
    }

    @SubscribeEvent
    public void onLivingUpdate1(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (world.field_72995_K || !entity.func_70089_S() || entity.field_70173_aa % 200 != 0 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        LOTRPlayerData playerData = LOTRLevelData.getData(player);
        LOTRFaction pledgeFaction = playerData.getPledgeFaction();
        if (pledgeFaction == null) {
            entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            return;
        }
        float reputation = playerData.getAlignment(pledgeFaction);
        LOTRFaction.FactionType factionType = this.getPriorityFactionType(pledgeFaction.getFactionTypes());
        double baseHealth = 20.0;
        double newHealth = baseHealth + Math.floor(reputation / 5000.0f);
        double fangorn = baseHealth + Math.floor(reputation / 3500.0f);
        double man = baseHealth + Math.floor(reputation / 4500.0f);
        switch (factionType) {
            case TYPE_ORC: {
                newHealth = Math.min(newHealth, 24.0);
                break;
            }
            case TYPE_ELF: {
                newHealth = Math.min(newHealth, 30.0);
                break;
            }
            case TYPE_MAN: {
                newHealth = Math.min(newHealth, 24.0);
                break;
            }
            case TYPE_TREE: {
                newHealth = Math.max(newHealth, fangorn);
                newHealth = Math.min(newHealth, 34.0);
                break;
            }
            case TYPE_DWARF: {
                newHealth = Math.min(newHealth, 26.0);
                break;
            }
            case TYPE_TROLL: {
                newHealth = Math.min(newHealth, 30.0);
            }
        }
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newHealth);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        if (!(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        EntityLivingBase target = event.entityLiving;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        LOTRPlayerData playerData = LOTRLevelData.getData(player);
        LOTRFaction pledgeFaction = playerData.getPledgeFaction();
        if (pledgeFaction == null) {
            return;
        }
        LOTRFaction.FactionType factionType = this.getPriorityFactionType(pledgeFaction.getFactionTypes());
        float reputation = playerData.getAlignment(pledgeFaction);
        float originalDamage = event.ammount;
        switch (factionType) {
            case TYPE_TREE: {
                if (event.source.func_76347_k()) {
                    event.ammount = originalDamage * 1.5f;
                }
                if (reputation > 20000.0f && this.isTargetOrcWargOrTroll(target)) {
                    event.ammount = originalDamage * 1.2f;
                }
                if (!player.func_70644_a(LOTRPotions.blood)) break;
                player.func_82170_o(LOTRPotions.blood.field_76415_H);
                break;
            }
            case TYPE_TROLL: {
                if (reputation > 10000.0f) {
                    event.ammount = originalDamage * 0.85f;
                }
                if (!player.func_70644_a(LOTRPotions.broken)) break;
                player.func_82170_o(LOTRPotions.broken.field_76415_H);
                break;
            }
            case TYPE_ORC: {
                if (!(reputation > 10000.0f) || !(target instanceof EntityPlayer) && !(target instanceof LOTREntityMan)) break;
                event.ammount = originalDamage * 1.2f;
                break;
            }
            case TYPE_DWARF: {
                if (!(reputation > 10000.0f) || !this.isTargetOrcWargOrTroll(target)) break;
                event.ammount = originalDamage * 1.2f;
                break;
            }
            case TYPE_MAN: {
                if (!(reputation > 5000.0f)) break;
                event.ammount = originalDamage * 1.15f;
                break;
            }
            case TYPE_ELF: {
                if (!player.func_70644_a(Potion.field_76436_u)) break;
                player.func_82170_o(Potion.field_76436_u.field_76415_H);
            }
        }
    }

    private boolean isTargetOrcWargOrTroll(EntityLivingBase target) {
        return target instanceof LOTREntityOrc || target instanceof LOTREntityWarg || target instanceof LOTREntityTroll;
    }

    private boolean isTargetOfType(EntityLivingBase target, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isInstance(target)) continue;
            return true;
        }
        return false;
    }

    private void applyPotionDamageBoost(EntityPlayer player, Potion potion, LivingHurtEvent event, float extraDamage) {
        if (player.func_70644_a(Potion.field_76425_a[potion.field_76415_H])) {
            event.ammount += extraDamage;
        }
    }

    private boolean isTargetOrcWargOrTroll(Entity entity) {
        return entity instanceof LOTREntityOrc || entity instanceof LOTREntityWarg || entity instanceof LOTREntityTroll;
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!(event.block instanceof BlockSponge) || !(event.world.func_72807_a(event.x, event.z) instanceof LOTRBiomeGenOcean)) {
            return;
        }
        LOTRLevelData.getData(event.getPlayer()).addAchievement(LOTRAchievement.spongeBob);
    }

    @SubscribeEvent
    public void onPlayerUseItem(PlayerUseItemEvent.Start event) {
        boolean hasEffect;
        if (event.entityPlayer.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean isMilk = event.item.func_77973_b() == Items.field_151117_aB || event.item.func_77973_b() == LOTRMod.mugMilk;
        boolean bl = hasEffect = event.entityPlayer.func_82165_m(LOTRPotions.broken.field_76415_H) || event.entityPlayer.func_82165_m(LOTRPotions.curse.field_76415_H);
        if (isMilk && hasEffect) {
            event.setCanceled(true);
        }
    }
}

